/*
 * Decompiled with CFR 0.152.
 */
package OreSpawn.entities;

import OreSpawn.OreSpawnMain;
import OreSpawn.entities.Girlfriend;
import OreSpawn.entities.Lavrov;
import OreSpawn.entities.Putin;
import dangerzone.InventoryContainer;
import dangerzone.Player;
import dangerzone.Utils;
import dangerzone.entities.Cockroach;
import dangerzone.entities.Entity;
import dangerzone.entities.EntityLiving;
import dangerzone.items.Items;
import dangerzone.rendering.TextureMapper;
import dangerzone.world.World;
import slick.Texture;

public class Russian
extends EntityLiving {
    public Russian(World w) {
        super(w);
        this.maxrenderdist = 120;
        this.height = 1.9f;
        this.width = 0.85f;
        this.uniquename = "OreSpawn:Russian";
        this.moveSpeed = 0.28f;
        this.setMaxHealth(100.0f);
        this.setHealth(100.0f);
        this.setDefense(1.0f);
        this.setAttackDamage(2.0f);
        this.setMaxHunger(50.0f);
        this.setHunger(50.0f);
        this.setMaxAir(100.0f);
        this.setAir(100.0f);
        this.setExperience(100);
        this.searchDistance = 16.0f;
        this.attackRange = 3.0f;
        this.movefrequency = 55;
        this.canSwim = true;
        this.has_inventory = true;
        this.temperament = 2;
        this.enable_hostile = true;
        this.tower_defense_enable = false;
        this.enable_followfood = true;
        this.foodsearchDistance = 12;
        this.setCanDespawn(false);
        this.enable_buddy = true;
        this.findbuddydistance = 25;
        this.findbuddyfrequency = 35;
    }

    public void init() {
        super.init();
        if (this.world != null && this.world.isServer && this.getInitialized() == 0) {
            this.setInitialized(1);
            if (this.world.rand.nextInt(2) == 0) {
                int wt = this.world.rand.nextInt(4);
                int itd = 0;
                InventoryContainer ic = new InventoryContainer();
                if (wt == 0) {
                    itd = Items.silveraxe.itemID;
                }
                if (wt == 1) {
                    itd = Items.platinumaxe.itemID;
                }
                if (wt == 2) {
                    itd = Items.platinumsword.itemID;
                }
                if (wt == 3) {
                    itd = Items.silversword.itemID;
                }
                ic.iid = itd;
                ic.count = 1;
                ic.currentuses = 0;
                this.setHotbar(0, ic);
                this.sethotbarindex(0);
            }
        }
    }

    public boolean isBuddy(Entity e) {
        if (e instanceof Russian) {
            return true;
        }
        if (e instanceof Putin) {
            return true;
        }
        return e instanceof Lavrov;
    }

    public void doEntityAction(float deltaT) {
        this.temperament = this.getAttacking() ? 1 : 2;
        super.doEntityAction(deltaT);
    }

    public boolean isFoodItem(int iid) {
        if (iid == Items.moosemeat.itemID) {
            return true;
        }
        if (iid == Items.moosemeat_cooked.itemID) {
            return true;
        }
        if (iid == Items.goosemeat.itemID) {
            return true;
        }
        return iid == Items.goosemeat_cooked.itemID;
    }

    public String getLivingSound() {
        return null;
    }

    public String getHurtSound() {
        int i = this.world.rand.nextInt(3);
        if (i == 0) {
            return "DangerZone:ouch1";
        }
        if (i == 1) {
            return "DangerZone:ouch2";
        }
        return "DangerZone:ouch3";
    }

    public String getDeathSound() {
        return "OreSpawn:alo_death";
    }

    public void doDeathDrops() {
        if (this.world.rand.nextInt(10) == 1) {
            Utils.doDropRand((World)this.world, (int)0, (int)OreSpawnMain.trophyrussian.itemID, (float)1.0f, (int)this.dimension, (double)this.posx, (double)this.posy, (double)this.posz);
        }
        super.doDeathDrops();
    }

    public boolean isSuitableTarget(Entity e) {
        if (this.isIgnorable(e)) {
            return false;
        }
        if (e instanceof Lavrov) {
            return false;
        }
        if (e instanceof Putin) {
            return false;
        }
        if (e instanceof Russian) {
            return false;
        }
        if (e instanceof Cockroach) {
            return true;
        }
        if (e.temperament == 1 && this.CanProbablySeeEntity(e)) {
            return true;
        }
        if (e instanceof Player) {
            return false;
        }
        if (e instanceof Girlfriend) {
            return false;
        }
        return false;
    }

    public Texture getTexture() {
        if (this.texture == null) {
            this.texture = TextureMapper.getTexture((String)"orespawnres/skins/Russian.png");
        }
        return this.texture;
    }
}

